/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.network;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.utils.ExpandedStreamCodec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record GameSlotCompletePayload(class_2338 pos, int index, List<Card> cards, float x, float y, float z, float angle, class_2350 stackDirection, float maxStack, boolean centered) implements class_8710
{
    public static final class_8710.class_9154<GameSlotCompletePayload> TYPE = new class_8710.class_9154(Charta.id("game_slot_complete"));
    public static class_9139<ByteBuf, GameSlotCompletePayload> STREAM_CODEC = ExpandedStreamCodec.composite(class_2338.field_48404, GameSlotCompletePayload::pos, class_9135.field_49675, GameSlotCompletePayload::index, class_9135.method_56376(ArrayList::new, Card.STREAM_CODEC), GameSlotCompletePayload::cards, class_9135.field_48552, GameSlotCompletePayload::x, class_9135.field_48552, GameSlotCompletePayload::y, class_9135.field_48552, GameSlotCompletePayload::z, class_9135.field_48552, GameSlotCompletePayload::angle, class_2350.field_48450, GameSlotCompletePayload::stackDirection, class_9135.field_48552, GameSlotCompletePayload::maxStack, class_9135.field_48547, GameSlotCompletePayload::centered, GameSlotCompletePayload::new);

    public GameSlotCompletePayload(class_2338 pos, int index, GameSlot slot) {
        this(pos, index, slot.stream().toList(), slot.getX(), slot.getY(), slot.getZ(), slot.getAngle(), slot.getStackDirection(), slot.getMaxStack(), slot.isCentered());
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handleClient(class_1657 player, GameSlotCompletePayload payload) {
        GameSlotCompletePayload.updateGameSlot(payload);
    }

    @Environment(value=EnvType.CLIENT)
    private static void updateGameSlot(GameSlotCompletePayload payload) {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level != null) {
            level.method_35230(payload.pos, ModBlockEntityTypes.CARD_TABLE).ifPresent(cardTable -> {
                LinkedList<Card> list = new LinkedList<Card>(payload.cards);
                if (payload.index == cardTable.getSlotCount()) {
                    cardTable.addSlot(new GameSlot(list, payload.x, payload.y, payload.z, payload.angle, payload.stackDirection, payload.maxStack, payload.centered));
                } else {
                    GameSlot tracked = cardTable.getSlot(payload.index);
                    tracked.setCards(list);
                    tracked.setX(payload.x);
                    tracked.setY(payload.y);
                    tracked.setZ(payload.z);
                    tracked.setAngle(payload.angle);
                    tracked.setStackDirection(payload.stackDirection);
                    tracked.setMaxStack(payload.maxStack);
                    tracked.setCentered(payload.centered);
                }
            });
        }
    }
}

